%------------------------------------------------------------------------------
% File     : DAT246^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Infinite streams (sequences/lists) 156
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : stream__156.p [Bla16]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.67 v7.2.0, 1.00 v7.1.0
% Syntax   : Number of formulae    :  319 (  68 unt;  44 typ;   0 def)
%            Number of atoms       :  875 ( 188 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 3635 (  86   ~;  21   |;  39   &;2963   @)
%                                         (   0 <=>; 526  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   9 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  163 ( 163   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   43 (  42 usr;   3 con; 0-4 aty)
%            Number of variables   :  991 (  41   ^; 873   !;  41   ?; 991   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:41:00.835
%------------------------------------------------------------------------------
%----Could-be-implicit typings (5)
thf(ty_t_Stream__Mirabelle__hbrgyiwlrc_Ostream,type,
    stream170649215stream: $tType > $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (39)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ominus,type,
    minus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Olinear__continuum,type,
    condit1656338222tinuum: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Hilbert__Choice_OGreatestM,type,
    hilbert_GreatestM: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( A > $o ) > A ) ).

thf(sy_c_List_Ocount__list,type,
    count_list: 
      !>[A: $tType] : ( ( list @ A ) > A > nat ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_Otl,type,
    tl: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist__ex,type,
    list_ex: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Onth,type,
    nth: 
      !>[A: $tType] : ( ( list @ A ) > nat > A ) ).

thf(sy_c_List_Oremdups__adj,type,
    remdups_adj: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Oshift,type,
    stream1035003186_shift: 
      !>[A: $tType] : ( ( list @ A ) > ( stream170649215stream @ A ) > ( stream170649215stream @ A ) ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Osnth,type,
    stream370371455e_snth: 
      !>[A: $tType] : ( ( stream170649215stream @ A ) > nat > A ) ).

thf(sy_v_n,type,
    n: nat ).

thf(sy_v_s,type,
    s: stream170649215stream @ a ).

thf(sy_v_xs,type,
    xs: list @ a ).

%----Relevant facts (254)
thf(fact_0_shift__left__inj,axiom,
    ! [A: $tType,Xs: list @ A,S1: stream170649215stream @ A,S2: stream170649215stream @ A] :
      ( ( ( stream1035003186_shift @ A @ Xs @ S1 )
        = ( stream1035003186_shift @ A @ Xs @ S2 ) )
      = ( S1 = S2 ) ) ).

% shift_left_inj
thf(fact_1_shift__snth__less,axiom,
    ! [A: $tType,P: nat,Xs: list @ A,S: stream170649215stream @ A] :
      ( ( ord_less @ nat @ P @ ( size_size @ ( list @ A ) @ Xs ) )
     => ( ( stream370371455e_snth @ A @ ( stream1035003186_shift @ A @ Xs @ S ) @ P )
        = ( nth @ A @ Xs @ P ) ) ) ).

% shift_snth_less
thf(fact_2_nth__equalityI,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
        = ( size_size @ ( list @ A ) @ Ys ) )
     => ( ! [I: nat] :
            ( ( ord_less @ nat @ I @ ( size_size @ ( list @ A ) @ Xs ) )
           => ( ( nth @ A @ Xs @ I )
              = ( nth @ A @ Ys @ I ) ) )
       => ( Xs = Ys ) ) ) ).

% nth_equalityI
thf(fact_3_Skolem__list__nth,axiom,
    ! [A: $tType,K: nat,P2: nat > A > $o] :
      ( ( ! [I2: nat] :
            ( ( ord_less @ nat @ I2 @ K )
           => ( ^ [P3: A > $o] :
                ? [X: A] : ( P3 @ X )
              @ ( P2 @ I2 ) ) ) )
      = ( ? [Xs2: list @ A] :
            ( ( ( size_size @ ( list @ A ) @ Xs2 )
              = K )
            & ! [I2: nat] :
                ( ( ord_less @ nat @ I2 @ K )
               => ( P2 @ I2 @ ( nth @ A @ Xs2 @ I2 ) ) ) ) ) ) ).

% Skolem_list_nth
thf(fact_4_list__eq__iff__nth__eq,axiom,
    ! [A: $tType] :
      ( ( ^ [Y: list @ A,Z: list @ A] : ( Y = Z ) )
      = ( ^ [Xs2: list @ A,Ys2: list @ A] :
            ( ( ( size_size @ ( list @ A ) @ Xs2 )
              = ( size_size @ ( list @ A ) @ Ys2 ) )
            & ! [I2: nat] :
                ( ( ord_less @ nat @ I2 @ ( size_size @ ( list @ A ) @ Xs2 ) )
               => ( ( nth @ A @ Xs2 @ I2 )
                  = ( nth @ A @ Ys2 @ I2 ) ) ) ) ) ) ).

% list_eq_iff_nth_eq
thf(fact_5_minus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A2: A > B,B2: A > B,X2: A] : ( minus_minus @ B @ ( A2 @ X2 ) @ ( B2 @ X2 ) ) ) ) ) ).

% minus_apply
thf(fact_6_diff__less__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ( ord_less @ nat @ M @ L )
       => ( ord_less @ nat @ ( minus_minus @ nat @ L @ N ) @ ( minus_minus @ nat @ L @ M ) ) ) ) ).

% diff_less_mono2
thf(fact_7_less__imp__diff__less,axiom,
    ! [J: nat,K: nat,N: nat] :
      ( ( ord_less @ nat @ J @ K )
     => ( ord_less @ nat @ ( minus_minus @ nat @ J @ N ) @ K ) ) ).

% less_imp_diff_less
thf(fact_8_length__induct,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,Xs: list @ A] :
      ( ! [Xs3: list @ A] :
          ( ! [Ys3: list @ A] :
              ( ( ord_less @ nat @ ( size_size @ ( list @ A ) @ Ys3 ) @ ( size_size @ ( list @ A ) @ Xs3 ) )
             => ( P2 @ Ys3 ) )
         => ( P2 @ Xs3 ) )
     => ( P2 @ Xs ) ) ).

% length_induct
thf(fact_9_diff__strict__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,D: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less @ A @ D @ C )
           => ( ord_less @ A @ ( minus_minus @ A @ A3 @ C ) @ ( minus_minus @ A @ B3 @ D ) ) ) ) ) ).

% diff_strict_mono
thf(fact_10_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A,D: A] :
          ( ( ( minus_minus @ A @ A3 @ B3 )
            = ( minus_minus @ A @ C @ D ) )
         => ( ( ord_less @ A @ A3 @ B3 )
            = ( ord_less @ A @ C @ D ) ) ) ) ).

% diff_eq_diff_less
thf(fact_11_diff__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ord_less @ A @ ( minus_minus @ A @ C @ A3 ) @ ( minus_minus @ A @ C @ B3 ) ) ) ) ).

% diff_strict_left_mono
thf(fact_12_diff__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ord_less @ A @ ( minus_minus @ A @ A3 @ C ) @ ( minus_minus @ A @ B3 @ C ) ) ) ) ).

% diff_strict_right_mono
thf(fact_13_shift__snth__ge,axiom,
    ! [A: $tType,Xs: list @ A,P: nat,S: stream170649215stream @ A] :
      ( ( ord_less_eq @ nat @ ( size_size @ ( list @ A ) @ Xs ) @ P )
     => ( ( stream370371455e_snth @ A @ ( stream1035003186_shift @ A @ Xs @ S ) @ P )
        = ( stream370371455e_snth @ A @ S @ ( minus_minus @ nat @ P @ ( size_size @ ( list @ A ) @ Xs ) ) ) ) ) ).

% shift_snth_ge
thf(fact_14_diff__diff__cancel,axiom,
    ! [I3: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I3 @ N )
     => ( ( minus_minus @ nat @ N @ ( minus_minus @ nat @ N @ I3 ) )
        = I3 ) ) ).

% diff_diff_cancel
thf(fact_15_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_16_le__trans,axiom,
    ! [I3: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I3 @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I3 @ K ) ) ) ).

% le_trans
thf(fact_17_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_18_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_19_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_20_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A,D: A] :
          ( ( ( minus_minus @ A @ A3 @ B3 )
            = ( minus_minus @ A @ C @ D ) )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
            = ( ord_less_eq @ A @ C @ D ) ) ) ) ).

% diff_eq_diff_less_eq
thf(fact_21_diff__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ A3 @ C ) @ ( minus_minus @ A @ B3 @ C ) ) ) ) ).

% diff_right_mono
thf(fact_22_diff__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ C @ A3 ) @ ( minus_minus @ A @ C @ B3 ) ) ) ) ).

% diff_left_mono
thf(fact_23_diff__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,D: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ D @ C )
           => ( ord_less_eq @ A @ ( minus_minus @ A @ A3 @ C ) @ ( minus_minus @ A @ B3 @ D ) ) ) ) ) ).

% diff_mono
thf(fact_24_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I3: nat,J: nat] :
      ( ! [I: nat,J2: nat] :
          ( ( ord_less @ nat @ I @ J2 )
         => ( ord_less @ nat @ ( F @ I ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I3 @ J )
       => ( ord_less_eq @ nat @ ( F @ I3 ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_25_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( M != N )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_26_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less @ nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_27_le__eq__less__or__eq,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less @ nat @ M2 @ N2 )
          | ( M2 = N2 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_28_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_29_nat__less__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less_eq @ nat @ M2 @ N2 )
          & ( M2 != N2 ) ) ) ) ).

% nat_less_le
thf(fact_30_diff__le__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ord_less_eq @ nat @ ( minus_minus @ nat @ L @ N ) @ ( minus_minus @ nat @ L @ M ) ) ) ).

% diff_le_mono2
thf(fact_31_le__diff__iff_H,axiom,
    ! [A3: nat,C: nat,B3: nat] :
      ( ( ord_less_eq @ nat @ A3 @ C )
     => ( ( ord_less_eq @ nat @ B3 @ C )
       => ( ( ord_less_eq @ nat @ ( minus_minus @ nat @ C @ A3 ) @ ( minus_minus @ nat @ C @ B3 ) )
          = ( ord_less_eq @ nat @ B3 @ A3 ) ) ) ) ).

% le_diff_iff'
thf(fact_32_diff__le__self,axiom,
    ! [M: nat,N: nat] : ( ord_less_eq @ nat @ ( minus_minus @ nat @ M @ N ) @ M ) ).

% diff_le_self
thf(fact_33_diff__le__mono,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ord_less_eq @ nat @ ( minus_minus @ nat @ M @ L ) @ ( minus_minus @ nat @ N @ L ) ) ) ).

% diff_le_mono
thf(fact_34_Nat_Odiff__diff__eq,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ K @ M )
     => ( ( ord_less_eq @ nat @ K @ N )
       => ( ( minus_minus @ nat @ ( minus_minus @ nat @ M @ K ) @ ( minus_minus @ nat @ N @ K ) )
          = ( minus_minus @ nat @ M @ N ) ) ) ) ).

% Nat.diff_diff_eq
thf(fact_35_le__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ K @ M )
     => ( ( ord_less_eq @ nat @ K @ N )
       => ( ( ord_less_eq @ nat @ ( minus_minus @ nat @ M @ K ) @ ( minus_minus @ nat @ N @ K ) )
          = ( ord_less_eq @ nat @ M @ N ) ) ) ) ).

% le_diff_iff
thf(fact_36_eq__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ K @ M )
     => ( ( ord_less_eq @ nat @ K @ N )
       => ( ( ( minus_minus @ nat @ M @ K )
            = ( minus_minus @ nat @ N @ K ) )
          = ( M = N ) ) ) ) ).

% eq_diff_iff
thf(fact_37_diff__less__mono,axiom,
    ! [A3: nat,B3: nat,C: nat] :
      ( ( ord_less @ nat @ A3 @ B3 )
     => ( ( ord_less_eq @ nat @ C @ A3 )
       => ( ord_less @ nat @ ( minus_minus @ nat @ A3 @ C ) @ ( minus_minus @ nat @ B3 @ C ) ) ) ) ).

% diff_less_mono
thf(fact_38_less__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ K @ M )
     => ( ( ord_less_eq @ nat @ K @ N )
       => ( ( ord_less @ nat @ ( minus_minus @ nat @ M @ K ) @ ( minus_minus @ nat @ N @ K ) )
          = ( ord_less @ nat @ M @ N ) ) ) ) ).

% less_diff_iff
thf(fact_39_diff__right__commute,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A3: A,C: A,B3: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A3 @ C ) @ B3 )
          = ( minus_minus @ A @ ( minus_minus @ A @ A3 @ B3 ) @ C ) ) ) ).

% diff_right_commute
thf(fact_40_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A,D: A] :
          ( ( ( minus_minus @ A @ A3 @ B3 )
            = ( minus_minus @ A @ C @ D ) )
         => ( ( A3 = B3 )
            = ( C = D ) ) ) ) ).

% diff_eq_diff_eq
thf(fact_41_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A2: A > B,B2: A > B,X2: A] : ( minus_minus @ B @ ( A2 @ X2 ) @ ( B2 @ X2 ) ) ) ) ) ).

% fun_diff_def
thf(fact_42_infinite__descent__measure,axiom,
    ! [A: $tType,P2: A > $o,V: A > nat,X3: A] :
      ( ! [X4: A] :
          ( ~ ( P2 @ X4 )
         => ? [Y2: A] :
              ( ( ord_less @ nat @ ( V @ Y2 ) @ ( V @ X4 ) )
              & ~ ( P2 @ Y2 ) ) )
     => ( P2 @ X3 ) ) ).

% infinite_descent_measure
thf(fact_43_measure__induct__rule,axiom,
    ! [A: $tType,F: A > nat,P2: A > $o,A3: A] :
      ( ! [X4: A] :
          ( ! [Y2: A] :
              ( ( ord_less @ nat @ ( F @ Y2 ) @ ( F @ X4 ) )
             => ( P2 @ Y2 ) )
         => ( P2 @ X4 ) )
     => ( P2 @ A3 ) ) ).

% measure_induct_rule
thf(fact_44_linorder__neqE__nat,axiom,
    ! [X3: nat,Y3: nat] :
      ( ( X3 != Y3 )
     => ( ~ ( ord_less @ nat @ X3 @ Y3 )
       => ( ord_less @ nat @ Y3 @ X3 ) ) ) ).

% linorder_neqE_nat
thf(fact_45_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_46_infinite__descent,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ~ ( P2 @ N3 )
         => ? [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
              & ~ ( P2 @ M3 ) ) )
     => ( P2 @ N ) ) ).

% infinite_descent
thf(fact_47_nat__less__induct,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
             => ( P2 @ M3 ) )
         => ( P2 @ N3 ) )
     => ( P2 @ N ) ) ).

% nat_less_induct
thf(fact_48_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_49_measure__induct,axiom,
    ! [A: $tType,F: A > nat,P2: A > $o,A3: A] :
      ( ! [X4: A] :
          ( ! [Y2: A] :
              ( ( ord_less @ nat @ ( F @ Y2 ) @ ( F @ X4 ) )
             => ( P2 @ Y2 ) )
         => ( P2 @ X4 ) )
     => ( P2 @ A3 ) ) ).

% measure_induct
thf(fact_50_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less @ nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_51_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_52_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_53_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_54_neq__if__length__neq,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
       != ( size_size @ ( list @ A ) @ Ys ) )
     => ( Xs != Ys ) ) ).

% neq_if_length_neq
thf(fact_55_Ex__list__of__length,axiom,
    ! [A: $tType,N: nat] :
    ? [Xs3: list @ A] :
      ( ( size_size @ ( list @ A ) @ Xs3 )
      = N ) ).

% Ex_list_of_length
thf(fact_56_diff__commute,axiom,
    ! [I3: nat,J: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ I3 @ J ) @ K )
      = ( minus_minus @ nat @ ( minus_minus @ nat @ I3 @ K ) @ J ) ) ).

% diff_commute
thf(fact_57_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( ord_less_eq @ A @ X3 @ X3 ) ) ).

% order_refl
thf(fact_58_ex__has__greatest__nat,axiom,
    ! [A: $tType,P2: A > $o,K: A,M: A > nat,B3: nat] :
      ( ( P2 @ K )
     => ( ! [Y4: A] :
            ( ( P2 @ Y4 )
           => ( ord_less @ nat @ ( M @ Y4 ) @ B3 ) )
       => ? [X4: A] :
            ( ( P2 @ X4 )
            & ! [Y2: A] :
                ( ( P2 @ Y2 )
               => ( ord_less_eq @ nat @ ( M @ Y2 ) @ ( M @ X4 ) ) ) ) ) ) ).

% ex_has_greatest_nat
thf(fact_59_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,P2: A > $o] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( P2 @ A3 )
           => ( ~ ( P2 @ B3 )
             => ? [C2: A] :
                  ( ( ord_less_eq @ A @ A3 @ C2 )
                  & ( ord_less_eq @ A @ C2 @ B3 )
                  & ! [X5: A] :
                      ( ( ( ord_less_eq @ A @ A3 @ X5 )
                        & ( ord_less @ A @ X5 @ C2 ) )
                     => ( P2 @ X5 ) )
                  & ! [D2: A] :
                      ( ! [X4: A] :
                          ( ( ( ord_less_eq @ A @ A3 @ X4 )
                            & ( ord_less @ A @ X4 @ D2 ) )
                         => ( P2 @ X4 ) )
                     => ( ord_less_eq @ A @ D2 @ C2 ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_60_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( A3 != B3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( ord_less @ A @ A3 @ B3 ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_61_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ord_less_eq @ A @ B3 @ A3 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_62_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( ord_less_eq @ A @ B4 @ A4 )
              & ( A4 != B4 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_63_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( ord_less @ A @ B4 @ A4 )
              | ( A4 = B4 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_64_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ord_less_eq @ A @ A3 @ B3 ) ) ) ).

% order.strict_implies_order
thf(fact_65_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,Z2: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X3 @ W )
               => ( ( ord_less @ A @ W @ Y3 )
                 => ( ord_less_eq @ A @ W @ Z2 ) ) )
           => ( ord_less_eq @ A @ Y3 @ Z2 ) ) ) ) ).

% dense_le_bounded
thf(fact_66_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z2: A,X3: A,Y3: A] :
          ( ( ord_less @ A @ Z2 @ X3 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z2 @ W )
               => ( ( ord_less @ A @ W @ X3 )
                 => ( ord_less_eq @ A @ Y3 @ W ) ) )
           => ( ord_less_eq @ A @ Y3 @ Z2 ) ) ) ) ).

% dense_ge_bounded
thf(fact_67_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less @ A @ C @ A3 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_68_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( A3 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_69_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less_eq @ A @ C @ A3 ) ) ) ) ).

% dual_order.trans
thf(fact_70_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P2: A > A > $o,A3: A,B3: A] :
          ( ! [A5: A,B5: A] :
              ( ( ord_less_eq @ A @ A5 @ B5 )
             => ( P2 @ A5 @ B5 ) )
         => ( ! [A5: A,B5: A] :
                ( ( P2 @ B5 @ A5 )
               => ( P2 @ A5 @ B5 ) )
           => ( P2 @ A3 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_71_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A] : ( ord_less_eq @ A @ A3 @ A3 ) ) ).

% dual_order.refl
thf(fact_72_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,Z2: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
         => ( ( ord_less_eq @ A @ Y3 @ Z2 )
           => ( ord_less_eq @ A @ X3 @ Z2 ) ) ) ) ).

% order_trans
thf(fact_73_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A3 )
           => ( A3 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_74_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_75_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_76_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y3: A,X3: A] :
          ( ( ord_less_eq @ A @ Y3 @ X3 )
         => ( ( ord_less_eq @ A @ X3 @ Y3 )
            = ( X3 = Y3 ) ) ) ) ).

% antisym_conv
thf(fact_77_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,Z2: A] :
          ( ( ( ord_less_eq @ A @ X3 @ Y3 )
           => ~ ( ord_less_eq @ A @ Y3 @ Z2 ) )
         => ( ( ( ord_less_eq @ A @ Y3 @ X3 )
             => ~ ( ord_less_eq @ A @ X3 @ Z2 ) )
           => ( ( ( ord_less_eq @ A @ X3 @ Z2 )
               => ~ ( ord_less_eq @ A @ Z2 @ Y3 ) )
             => ( ( ( ord_less_eq @ A @ Z2 @ Y3 )
                 => ~ ( ord_less_eq @ A @ Y3 @ X3 ) )
               => ( ( ( ord_less_eq @ A @ Y3 @ Z2 )
                   => ~ ( ord_less_eq @ A @ Z2 @ X3 ) )
                 => ~ ( ( ord_less_eq @ A @ Z2 @ X3 )
                     => ~ ( ord_less_eq @ A @ X3 @ Y3 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_78_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% order.trans
thf(fact_79_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ~ ( ord_less_eq @ A @ X3 @ Y3 )
         => ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ).

% le_cases
thf(fact_80_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( X3 = Y3 )
         => ( ord_less_eq @ A @ X3 @ Y3 ) ) ) ).

% eq_refl
thf(fact_81_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
          | ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ).

% linear
thf(fact_82_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
         => ( ( ord_less_eq @ A @ Y3 @ X3 )
           => ( X3 = Y3 ) ) ) ) ).

% antisym
thf(fact_83_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y: A,Z: A] : ( Y = Z ) )
        = ( ^ [X2: A,Y5: A] :
              ( ( ord_less_eq @ A @ X2 @ Y5 )
              & ( ord_less_eq @ A @ Y5 @ X2 ) ) ) ) ) ).

% eq_iff
thf(fact_84_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ( F @ B3 )
              = C )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ B @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ B @ ( F @ A3 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_85_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( A3
            = ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_86_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F @ B3 ) @ C )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ C3 @ ( F @ A3 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_87_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_88_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
            ! [X2: A] : ( ord_less_eq @ B @ ( F2 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% le_fun_def
thf(fact_89_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B] :
          ( ! [X4: A] : ( ord_less_eq @ B @ ( F @ X4 ) @ ( G @ X4 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_90_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X3: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funE
thf(fact_91_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X3: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funD
thf(fact_92_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( A3
            = ( F @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_93_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > B,C: B] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ( F @ B3 )
              = C )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ B @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ B @ ( F @ A3 ) @ C ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_94_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( ord_less @ A @ A3 @ ( F @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_95_order__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > C3,C: C3] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less @ C3 @ ( F @ B3 ) @ C )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F @ A3 ) @ C ) ) ) ) ) ).

% order_less_subst2
thf(fact_96_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A @ ( type2 @ A ) )
     => ! [X3: A] :
        ? [Y4: A] : ( ord_less @ A @ Y4 @ X3 ) ) ).

% lt_ex
thf(fact_97_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A @ ( type2 @ A ) )
     => ! [X3: A] :
        ? [X1: A] : ( ord_less @ A @ X3 @ X1 ) ) ).

% gt_ex
thf(fact_98_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( X3 != Y3 )
         => ( ~ ( ord_less @ A @ X3 @ Y3 )
           => ( ord_less @ A @ Y3 @ X3 ) ) ) ) ).

% neqE
thf(fact_99_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( X3 != Y3 )
          = ( ( ord_less @ A @ X3 @ Y3 )
            | ( ord_less @ A @ Y3 @ X3 ) ) ) ) ).

% neq_iff
thf(fact_100_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A3 ) ) ) ).

% order.asym
thf(fact_101_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ? [Z3: A] :
              ( ( ord_less @ A @ X3 @ Z3 )
              & ( ord_less @ A @ Z3 @ Y3 ) ) ) ) ).

% dense
thf(fact_102_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( X3 != Y3 ) ) ) ).

% less_imp_neq
thf(fact_103_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ~ ( ord_less @ A @ Y3 @ X3 ) ) ) ).

% less_asym
thf(fact_104_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A3 ) ) ) ).

% less_asym'
thf(fact_105_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,Z2: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( ( ord_less @ A @ Y3 @ Z2 )
           => ( ord_less @ A @ X3 @ Z2 ) ) ) ) ).

% less_trans
thf(fact_106_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
          | ( X3 = Y3 )
          | ( ord_less @ A @ Y3 @ X3 ) ) ) ).

% less_linear
thf(fact_107_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A] :
          ~ ( ord_less @ A @ X3 @ X3 ) ) ).

% less_irrefl
thf(fact_108_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% ord_eq_less_trans
thf(fact_109_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% ord_less_eq_trans
thf(fact_110_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ~ ( ord_less @ A @ A3 @ B3 ) ) ) ).

% dual_order.asym
thf(fact_111_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( X3 != Y3 ) ) ) ).

% less_imp_not_eq
thf(fact_112_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ~ ( ord_less @ A @ Y3 @ X3 ) ) ) ).

% less_not_sym
thf(fact_113_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P2: A > $o,A3: A] :
          ( ! [X4: A] :
              ( ! [Y2: A] :
                  ( ( ord_less @ A @ Y2 @ X4 )
                 => ( P2 @ Y2 ) )
             => ( P2 @ X4 ) )
         => ( P2 @ A3 ) ) ) ).

% less_induct
thf(fact_114_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y3: A,X3: A] :
          ( ~ ( ord_less @ A @ Y3 @ X3 )
         => ( ( ~ ( ord_less @ A @ X3 @ Y3 ) )
            = ( X3 = Y3 ) ) ) ) ).

% antisym_conv3
thf(fact_115_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( Y3 != X3 ) ) ) ).

% less_imp_not_eq2
thf(fact_116_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,P2: $o] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( ( ord_less @ A @ Y3 @ X3 )
           => P2 ) ) ) ).

% less_imp_triv
thf(fact_117_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ~ ( ord_less @ A @ X3 @ Y3 )
         => ( ( X3 != Y3 )
           => ( ord_less @ A @ Y3 @ X3 ) ) ) ) ).

% linorder_cases
thf(fact_118_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ~ ( ord_less @ A @ A3 @ A3 ) ) ).

% dual_order.irrefl
thf(fact_119_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% order.strict_trans
thf(fact_120_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ~ ( ord_less @ A @ Y3 @ X3 ) ) ) ).

% less_imp_not_less
thf(fact_121_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ( ord_less @ A @ C @ B3 )
           => ( ord_less @ A @ C @ A3 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_122_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ~ ( ord_less @ A @ X3 @ Y3 ) )
          = ( ( ord_less @ A @ Y3 @ X3 )
            | ( X3 = Y3 ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_123_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( A3 != B3 ) ) ) ).

% order.strict_implies_not_eq
thf(fact_124_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( A3 != B3 ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_125_ex__gt__or__lt,axiom,
    ! [A: $tType] :
      ( ( condit1656338222tinuum @ A @ ( type2 @ A ) )
     => ! [A3: A] :
        ? [B5: A] :
          ( ( ord_less @ A @ A3 @ B5 )
          | ( ord_less @ A @ B5 @ A3 ) ) ) ).

% ex_gt_or_lt
thf(fact_126_ex__has__least__nat,axiom,
    ! [A: $tType,P2: A > $o,K: A,M: A > nat] :
      ( ( P2 @ K )
     => ? [X4: A] :
          ( ( P2 @ X4 )
          & ! [Y2: A] :
              ( ( P2 @ Y2 )
             => ( ord_less_eq @ nat @ ( M @ X4 ) @ ( M @ Y2 ) ) ) ) ) ).

% ex_has_least_nat
thf(fact_127_leD,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y3: A,X3: A] :
          ( ( ord_less_eq @ A @ Y3 @ X3 )
         => ~ ( ord_less @ A @ X3 @ Y3 ) ) ) ).

% leD
thf(fact_128_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ~ ( ord_less @ A @ X3 @ Y3 )
         => ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ).

% leI
thf(fact_129_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X2: A,Y5: A] :
              ( ( ord_less @ A @ X2 @ Y5 )
              | ( X2 = Y5 ) ) ) ) ) ).

% le_less
thf(fact_130_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X2: A,Y5: A] :
              ( ( ord_less_eq @ A @ X2 @ Y5 )
              & ( X2 != Y5 ) ) ) ) ) ).

% less_le
thf(fact_131_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ ( F @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_132_order__le__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less @ C3 @ ( F @ B3 ) @ C )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F @ A3 ) @ C ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_133_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( ord_less @ A @ A3 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_134_order__less__le__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > C3,C: C3] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F @ B3 ) @ C )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F @ A3 ) @ C ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_135_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ~ ( ord_less_eq @ A @ X3 @ Y3 ) )
          = ( ord_less @ A @ Y3 @ X3 ) ) ) ).

% not_le
thf(fact_136_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ~ ( ord_less @ A @ X3 @ Y3 ) )
          = ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ).

% not_less
thf(fact_137_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( A3 != B3 )
           => ( ord_less @ A @ A3 @ B3 ) ) ) ) ).

% le_neq_trans
thf(fact_138_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( ord_less_eq @ A @ X3 @ Y3 ) ) ) ).

% less_imp_le
thf(fact_139_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ~ ( ord_less @ A @ X3 @ Y3 )
         => ( ( ord_less_eq @ A @ X3 @ Y3 )
            = ( X3 = Y3 ) ) ) ) ).

% antisym_conv1
thf(fact_140_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
         => ( ( ~ ( ord_less @ A @ X3 @ Y3 ) )
            = ( X3 = Y3 ) ) ) ) ).

% antisym_conv2
thf(fact_141_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,Z2: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
         => ( ( ord_less @ A @ Y3 @ Z2 )
           => ( ord_less @ A @ X3 @ Z2 ) ) ) ) ).

% le_less_trans
thf(fact_142_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A,Z2: A] :
          ( ( ord_less @ A @ X3 @ Y3 )
         => ( ( ord_less_eq @ A @ Y3 @ Z2 )
           => ( ord_less @ A @ X3 @ Z2 ) ) ) ) ).

% less_le_trans
thf(fact_143_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z2: A,Y3: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ Z2 @ X4 )
             => ( ord_less_eq @ A @ Y3 @ X4 ) )
         => ( ord_less_eq @ A @ Y3 @ Z2 ) ) ) ).

% dense_ge
thf(fact_144_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Y3: A,Z2: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Y3 )
             => ( ord_less_eq @ A @ X4 @ Z2 ) )
         => ( ord_less_eq @ A @ Y3 @ Z2 ) ) ) ).

% dense_le
thf(fact_145_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
          | ( ord_less @ A @ Y3 @ X3 ) ) ) ).

% le_less_linear
thf(fact_146_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y3 )
         => ( ( ord_less @ A @ X3 @ Y3 )
            | ( X3 = Y3 ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_147_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X2: A,Y5: A] :
              ( ( ord_less_eq @ A @ X2 @ Y5 )
              & ~ ( ord_less_eq @ A @ Y5 @ X2 ) ) ) ) ) ).

% less_le_not_le
thf(fact_148_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y3: A,X3: A] :
          ( ~ ( ord_less_eq @ A @ Y3 @ X3 )
         => ( ord_less @ A @ X3 @ Y3 ) ) ) ).

% not_le_imp_less
thf(fact_149_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% order.strict_trans1
thf(fact_150_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% order.strict_trans2
thf(fact_151_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less @ A @ A4 @ B4 )
              | ( A4 = B4 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_152_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ A4 @ B4 )
              & ( A4 != B4 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_153_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less @ A @ C @ B3 )
           => ( ord_less @ A @ C @ A3 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_154_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ~ ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% minf(8)
thf(fact_155_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% minf(6)
thf(fact_156_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% pinf(8)
thf(fact_157_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ~ ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% pinf(6)
thf(fact_158_sorted__nth__mono,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,I3: nat,J: nat] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( ord_less_eq @ nat @ I3 @ J )
           => ( ( ord_less @ nat @ J @ ( size_size @ ( list @ A ) @ Xs ) )
             => ( ord_less_eq @ A @ ( nth @ A @ Xs @ I3 ) @ ( nth @ A @ Xs @ J ) ) ) ) ) ) ).

% sorted_nth_mono
thf(fact_159_sorted__nth__monoI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ! [I: nat,J2: nat] :
              ( ( ord_less_eq @ nat @ I @ J2 )
             => ( ( ord_less @ nat @ J2 @ ( size_size @ ( list @ A ) @ Xs ) )
               => ( ord_less_eq @ A @ ( nth @ A @ Xs @ I ) @ ( nth @ A @ Xs @ J2 ) ) ) )
         => ( linorder_sorted @ A @ Xs ) ) ) ).

% sorted_nth_monoI
thf(fact_160_sorted__equals__nth__mono,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [Xs2: list @ A] :
            ! [J3: nat] :
              ( ( ord_less @ nat @ J3 @ ( size_size @ ( list @ A ) @ Xs2 ) )
             => ! [I2: nat] :
                  ( ( ord_less_eq @ nat @ I2 @ J3 )
                 => ( ord_less_eq @ A @ ( nth @ A @ Xs2 @ I2 ) @ ( nth @ A @ Xs2 @ J3 ) ) ) ) ) ) ) ).

% sorted_equals_nth_mono
thf(fact_161_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
              ( ( ord_less_eq @ ( A > B ) @ F2 @ G2 )
              & ~ ( ord_less_eq @ ( A > B ) @ G2 @ F2 ) ) ) ) ) ).

% less_fun_def
thf(fact_162_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P2: A > $o,P4: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z4 @ X4 )
             => ( ( P2 @ X4 )
                = ( P4 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z4 @ X4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z3 @ X5 )
               => ( ( ( P2 @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P4 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_163_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P2: A > $o,P4: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z4 @ X4 )
             => ( ( P2 @ X4 )
                = ( P4 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z4 @ X4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z3 @ X5 )
               => ( ( ( P2 @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P4 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_164_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(3)
thf(fact_165_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(4)
thf(fact_166_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ~ ( ord_less @ A @ X5 @ T ) ) ) ).

% pinf(5)
thf(fact_167_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( ord_less @ A @ T @ X5 ) ) ) ).

% pinf(7)
thf(fact_168_pinf_I11_J,axiom,
    ! [C3: $tType,D3: $tType] :
      ( ( ord @ C3 @ ( type2 @ C3 ) )
     => ! [F3: D3] :
        ? [Z3: C3] :
        ! [X5: C3] :
          ( ( ord_less @ C3 @ Z3 @ X5 )
         => ( F3 = F3 ) ) ) ).

% pinf(11)
thf(fact_169_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P2: A > $o,P4: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z4 )
             => ( ( P2 @ X4 )
                = ( P4 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z3 )
               => ( ( ( P2 @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P4 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_170_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P2: A > $o,P4: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z4 )
             => ( ( P2 @ X4 )
                = ( P4 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z3 )
               => ( ( ( P2 @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P4 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_171_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( X5 != T ) ) ) ).

% minf(3)
thf(fact_172_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( X5 != T ) ) ) ).

% minf(4)
thf(fact_173_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( ord_less @ A @ X5 @ T ) ) ) ).

% minf(5)
thf(fact_174_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ~ ( ord_less @ A @ T @ X5 ) ) ) ).

% minf(7)
thf(fact_175_minf_I11_J,axiom,
    ! [C3: $tType,D3: $tType] :
      ( ( ord @ C3 @ ( type2 @ C3 ) )
     => ! [F3: D3] :
        ? [Z3: C3] :
        ! [X5: C3] :
          ( ( ord_less @ C3 @ X5 @ Z3 )
         => ( F3 = F3 ) ) ) ).

% minf(11)
thf(fact_176_sorted__rev__nth__mono,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,I3: nat,J: nat] :
          ( ( linorder_sorted @ A @ ( rev @ A @ Xs ) )
         => ( ( ord_less_eq @ nat @ I3 @ J )
           => ( ( ord_less @ nat @ J @ ( size_size @ ( list @ A ) @ Xs ) )
             => ( ord_less_eq @ A @ ( nth @ A @ Xs @ J ) @ ( nth @ A @ Xs @ I3 ) ) ) ) ) ) ).

% sorted_rev_nth_mono
thf(fact_177_list__ex__length,axiom,
    ! [A: $tType] :
      ( ( list_ex @ A )
      = ( ^ [P5: A > $o,Xs2: list @ A] :
          ? [N2: nat] :
            ( ( ord_less @ nat @ N2 @ ( size_size @ ( list @ A ) @ Xs2 ) )
            & ( P5 @ ( nth @ A @ Xs2 @ N2 ) ) ) ) ) ).

% list_ex_length
thf(fact_178_length__takeWhile__less__P__nth,axiom,
    ! [A: $tType,J: nat,P2: A > $o,Xs: list @ A] :
      ( ! [I: nat] :
          ( ( ord_less @ nat @ I @ J )
         => ( P2 @ ( nth @ A @ Xs @ I ) ) )
     => ( ( ord_less_eq @ nat @ J @ ( size_size @ ( list @ A ) @ Xs ) )
       => ( ord_less_eq @ nat @ J @ ( size_size @ ( list @ A ) @ ( takeWhile @ A @ P2 @ Xs ) ) ) ) ) ).

% length_takeWhile_less_P_nth
thf(fact_179_rev__rev__ident,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( rev @ A @ ( rev @ A @ Xs ) )
      = Xs ) ).

% rev_rev_ident
thf(fact_180_rev__is__rev__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( rev @ A @ Xs )
        = ( rev @ A @ Ys ) )
      = ( Xs = Ys ) ) ).

% rev_is_rev_conv
thf(fact_181_takeWhile__idem,axiom,
    ! [A: $tType,P2: A > $o,Xs: list @ A] :
      ( ( takeWhile @ A @ P2 @ ( takeWhile @ A @ P2 @ Xs ) )
      = ( takeWhile @ A @ P2 @ Xs ) ) ).

% takeWhile_idem
thf(fact_182_length__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( size_size @ ( list @ A ) @ ( rev @ A @ Xs ) )
      = ( size_size @ ( list @ A ) @ Xs ) ) ).

% length_rev
thf(fact_183_list__ex__rev,axiom,
    ! [A: $tType,P2: A > $o,Xs: list @ A] :
      ( ( list_ex @ A @ P2 @ ( rev @ A @ Xs ) )
      = ( list_ex @ A @ P2 @ Xs ) ) ).

% list_ex_rev
thf(fact_184_sorted__takeWhile,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,P2: A > $o] :
          ( ( linorder_sorted @ A @ Xs )
         => ( linorder_sorted @ A @ ( takeWhile @ A @ P2 @ Xs ) ) ) ) ).

% sorted_takeWhile
thf(fact_185_rev__swap,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( rev @ A @ Xs )
        = Ys )
      = ( Xs
        = ( rev @ A @ Ys ) ) ) ).

% rev_swap
thf(fact_186_length__takeWhile__le,axiom,
    ! [A: $tType,P2: A > $o,Xs: list @ A] : ( ord_less_eq @ nat @ ( size_size @ ( list @ A ) @ ( takeWhile @ A @ P2 @ Xs ) ) @ ( size_size @ ( list @ A ) @ Xs ) ) ).

% length_takeWhile_le
thf(fact_187_takeWhile__nth,axiom,
    ! [A: $tType,J: nat,P2: A > $o,Xs: list @ A] :
      ( ( ord_less @ nat @ J @ ( size_size @ ( list @ A ) @ ( takeWhile @ A @ P2 @ Xs ) ) )
     => ( ( nth @ A @ ( takeWhile @ A @ P2 @ Xs ) @ J )
        = ( nth @ A @ Xs @ J ) ) ) ).

% takeWhile_nth
thf(fact_188_nth__length__takeWhile,axiom,
    ! [A: $tType,P2: A > $o,Xs: list @ A] :
      ( ( ord_less @ nat @ ( size_size @ ( list @ A ) @ ( takeWhile @ A @ P2 @ Xs ) ) @ ( size_size @ ( list @ A ) @ Xs ) )
     => ~ ( P2 @ ( nth @ A @ Xs @ ( size_size @ ( list @ A ) @ ( takeWhile @ A @ P2 @ Xs ) ) ) ) ) ).

% nth_length_takeWhile
thf(fact_189_rev__nth,axiom,
    ! [A: $tType,N: nat,Xs: list @ A] :
      ( ( ord_less @ nat @ N @ ( size_size @ ( list @ A ) @ Xs ) )
     => ( ( nth @ A @ ( rev @ A @ Xs ) @ N )
        = ( nth @ A @ Xs @ ( minus_minus @ nat @ ( size_size @ ( list @ A ) @ Xs ) @ ( suc @ N ) ) ) ) ) ).

% rev_nth
thf(fact_190_count__le__length,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] : ( ord_less_eq @ nat @ ( count_list @ A @ Xs @ X3 ) @ ( size_size @ ( list @ A ) @ Xs ) ) ).

% count_le_length
thf(fact_191_GreatestM__nat__lemma,axiom,
    ! [A: $tType,P2: A > $o,K: A,M: A > nat,B3: nat] :
      ( ( P2 @ K )
     => ( ! [Y4: A] :
            ( ( P2 @ Y4 )
           => ( ord_less @ nat @ ( M @ Y4 ) @ B3 ) )
       => ( ( P2 @ ( hilbert_GreatestM @ A @ nat @ M @ P2 ) )
          & ! [Y2: A] :
              ( ( P2 @ Y2 )
             => ( ord_less_eq @ nat @ ( M @ Y2 ) @ ( M @ ( hilbert_GreatestM @ A @ nat @ M @ P2 ) ) ) ) ) ) ) ).

% GreatestM_nat_lemma
thf(fact_192_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_193_nat_Oinject,axiom,
    ! [X22: nat,Y22: nat] :
      ( ( ( suc @ X22 )
        = ( suc @ Y22 ) )
      = ( X22 = Y22 ) ) ).

% nat.inject
thf(fact_194_Suc__less__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% Suc_less_eq
thf(fact_195_Suc__mono,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) ) ) ).

% Suc_mono
thf(fact_196_lessI,axiom,
    ! [N: nat] : ( ord_less @ nat @ N @ ( suc @ N ) ) ).

% lessI
thf(fact_197_Suc__le__mono,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ N ) @ ( suc @ M ) )
      = ( ord_less_eq @ nat @ N @ M ) ) ).

% Suc_le_mono
thf(fact_198_diff__Suc__Suc,axiom,
    ! [M: nat,N: nat] :
      ( ( minus_minus @ nat @ ( suc @ M ) @ ( suc @ N ) )
      = ( minus_minus @ nat @ M @ N ) ) ).

% diff_Suc_Suc
thf(fact_199_Suc__diff__diff,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ ( suc @ M ) @ N ) @ ( suc @ K ) )
      = ( minus_minus @ nat @ ( minus_minus @ nat @ M @ N ) @ K ) ) ).

% Suc_diff_diff
thf(fact_200_not__less__less__Suc__eq,axiom,
    ! [N: nat,M: nat] :
      ( ~ ( ord_less @ nat @ N @ M )
     => ( ( ord_less @ nat @ N @ ( suc @ M ) )
        = ( N = M ) ) ) ).

% not_less_less_Suc_eq
thf(fact_201_strict__inc__induct,axiom,
    ! [I3: nat,J: nat,P2: nat > $o] :
      ( ( ord_less @ nat @ I3 @ J )
     => ( ! [I: nat] :
            ( ( J
              = ( suc @ I ) )
           => ( P2 @ I ) )
       => ( ! [I: nat] :
              ( ( ord_less @ nat @ I @ J )
             => ( ( P2 @ ( suc @ I ) )
               => ( P2 @ I ) ) )
         => ( P2 @ I3 ) ) ) ) ).

% strict_inc_induct
thf(fact_202_less__Suc__induct,axiom,
    ! [I3: nat,J: nat,P2: nat > nat > $o] :
      ( ( ord_less @ nat @ I3 @ J )
     => ( ! [I: nat] : ( P2 @ I @ ( suc @ I ) )
       => ( ! [I: nat,J2: nat,K2: nat] :
              ( ( ord_less @ nat @ I @ J2 )
             => ( ( ord_less @ nat @ J2 @ K2 )
               => ( ( P2 @ I @ J2 )
                 => ( ( P2 @ J2 @ K2 )
                   => ( P2 @ I @ K2 ) ) ) ) )
         => ( P2 @ I3 @ J ) ) ) ) ).

% less_Suc_induct
thf(fact_203_less__trans__Suc,axiom,
    ! [I3: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I3 @ J )
     => ( ( ord_less @ nat @ J @ K )
       => ( ord_less @ nat @ ( suc @ I3 ) @ K ) ) ) ).

% less_trans_Suc
thf(fact_204_Suc__less__SucD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) )
     => ( ord_less @ nat @ M @ N ) ) ).

% Suc_less_SucD
thf(fact_205_less__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ~ ( ord_less @ nat @ N @ M )
     => ( ( ord_less @ nat @ N @ ( suc @ M ) )
       => ( M = N ) ) ) ).

% less_antisym
thf(fact_206_Suc__less__eq2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( suc @ N ) @ M )
      = ( ? [M4: nat] :
            ( ( M
              = ( suc @ M4 ) )
            & ( ord_less @ nat @ N @ M4 ) ) ) ) ).

% Suc_less_eq2
thf(fact_207_not__less__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ~ ( ord_less @ nat @ M @ N ) )
      = ( ord_less @ nat @ N @ ( suc @ M ) ) ) ).

% not_less_eq
thf(fact_208_less__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N ) )
      = ( ( ord_less @ nat @ M @ N )
        | ( M = N ) ) ) ).

% less_Suc_eq
thf(fact_209_less__SucI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less @ nat @ M @ ( suc @ N ) ) ) ).

% less_SucI
thf(fact_210_less__SucE,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N ) )
     => ( ~ ( ord_less @ nat @ M @ N )
       => ( M = N ) ) ) ).

% less_SucE
thf(fact_211_Suc__lessI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ( ( suc @ M )
         != N )
       => ( ord_less @ nat @ ( suc @ M ) @ N ) ) ) ).

% Suc_lessI
thf(fact_212_Suc__lessE,axiom,
    ! [I3: nat,K: nat] :
      ( ( ord_less @ nat @ ( suc @ I3 ) @ K )
     => ~ ! [J2: nat] :
            ( ( ord_less @ nat @ I3 @ J2 )
           => ( K
             != ( suc @ J2 ) ) ) ) ).

% Suc_lessE
thf(fact_213_Suc__lessD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ N )
     => ( ord_less @ nat @ M @ N ) ) ).

% Suc_lessD
thf(fact_214_lessE,axiom,
    ! [I3: nat,K: nat] :
      ( ( ord_less @ nat @ I3 @ K )
     => ( ( K
         != ( suc @ I3 ) )
       => ~ ! [J2: nat] :
              ( ( ord_less @ nat @ I3 @ J2 )
             => ( K
               != ( suc @ J2 ) ) ) ) ) ).

% lessE
thf(fact_215_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [F: nat > A,N: nat,N4: nat] :
          ( ! [N3: nat] : ( ord_less @ A @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
         => ( ( ord_less @ nat @ N @ N4 )
           => ( ord_less @ A @ ( F @ N ) @ ( F @ N4 ) ) ) ) ) ).

% lift_Suc_mono_less
thf(fact_216_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [F: nat > A,N: nat,M: nat] :
          ( ! [N3: nat] : ( ord_less @ A @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
         => ( ( ord_less @ A @ ( F @ N ) @ ( F @ M ) )
            = ( ord_less @ nat @ N @ M ) ) ) ) ).

% lift_Suc_mono_less_iff
thf(fact_217_lift__Suc__antimono__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [F: nat > A,N: nat,N4: nat] :
          ( ! [N3: nat] : ( ord_less_eq @ A @ ( F @ ( suc @ N3 ) ) @ ( F @ N3 ) )
         => ( ( ord_less_eq @ nat @ N @ N4 )
           => ( ord_less_eq @ A @ ( F @ N4 ) @ ( F @ N ) ) ) ) ) ).

% lift_Suc_antimono_le
thf(fact_218_lift__Suc__mono__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [F: nat > A,N: nat,N4: nat] :
          ( ! [N3: nat] : ( ord_less_eq @ A @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
         => ( ( ord_less_eq @ nat @ N @ N4 )
           => ( ord_less_eq @ A @ ( F @ N ) @ ( F @ N4 ) ) ) ) ) ).

% lift_Suc_mono_le
thf(fact_219_le__imp__less__Suc,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ord_less @ nat @ M @ ( suc @ N ) ) ) ).

% le_imp_less_Suc
thf(fact_220_less__eq__Suc__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [N2: nat] : ( ord_less_eq @ nat @ ( suc @ N2 ) ) ) ) ).

% less_eq_Suc_le
thf(fact_221_less__Suc__eq__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% less_Suc_eq_le
thf(fact_222_le__less__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less @ nat @ N @ ( suc @ M ) )
        = ( N = M ) ) ) ).

% le_less_Suc_eq
thf(fact_223_Suc__le__lessD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ M ) @ N )
     => ( ord_less @ nat @ M @ N ) ) ).

% Suc_le_lessD
thf(fact_224_inc__induct,axiom,
    ! [I3: nat,J: nat,P2: nat > $o] :
      ( ( ord_less_eq @ nat @ I3 @ J )
     => ( ( P2 @ J )
       => ( ! [N3: nat] :
              ( ( ord_less_eq @ nat @ I3 @ N3 )
             => ( ( ord_less @ nat @ N3 @ J )
               => ( ( P2 @ ( suc @ N3 ) )
                 => ( P2 @ N3 ) ) ) )
         => ( P2 @ I3 ) ) ) ) ).

% inc_induct
thf(fact_225_dec__induct,axiom,
    ! [I3: nat,J: nat,P2: nat > $o] :
      ( ( ord_less_eq @ nat @ I3 @ J )
     => ( ( P2 @ I3 )
       => ( ! [N3: nat] :
              ( ( ord_less_eq @ nat @ I3 @ N3 )
             => ( ( ord_less @ nat @ N3 @ J )
               => ( ( P2 @ N3 )
                 => ( P2 @ ( suc @ N3 ) ) ) ) )
         => ( P2 @ J ) ) ) ) ).

% dec_induct
thf(fact_226_Suc__le__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ M ) @ N )
      = ( ord_less @ nat @ M @ N ) ) ).

% Suc_le_eq
thf(fact_227_Suc__leI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less_eq @ nat @ ( suc @ M ) @ N ) ) ).

% Suc_leI
thf(fact_228_n__not__Suc__n,axiom,
    ! [N: nat] :
      ( N
     != ( suc @ N ) ) ).

% n_not_Suc_n
thf(fact_229_Suc__inject,axiom,
    ! [X3: nat,Y3: nat] :
      ( ( ( suc @ X3 )
        = ( suc @ Y3 ) )
     => ( X3 = Y3 ) ) ).

% Suc_inject
thf(fact_230_zero__induct__lemma,axiom,
    ! [P2: nat > $o,K: nat,I3: nat] :
      ( ( P2 @ K )
     => ( ! [N3: nat] :
            ( ( P2 @ ( suc @ N3 ) )
           => ( P2 @ N3 ) )
       => ( P2 @ ( minus_minus @ nat @ K @ I3 ) ) ) ) ).

% zero_induct_lemma
thf(fact_231_full__nat__induct,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less_eq @ nat @ ( suc @ M3 ) @ N3 )
             => ( P2 @ M3 ) )
         => ( P2 @ N3 ) )
     => ( P2 @ N ) ) ).

% full_nat_induct
thf(fact_232_not__less__eq__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ~ ( ord_less_eq @ nat @ M @ N ) )
      = ( ord_less_eq @ nat @ ( suc @ N ) @ M ) ) ).

% not_less_eq_eq
thf(fact_233_Suc__n__not__le__n,axiom,
    ! [N: nat] :
      ~ ( ord_less_eq @ nat @ ( suc @ N ) @ N ) ).

% Suc_n_not_le_n
thf(fact_234_le__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ ( suc @ N ) )
      = ( ( ord_less_eq @ nat @ M @ N )
        | ( M
          = ( suc @ N ) ) ) ) ).

% le_Suc_eq
thf(fact_235_Suc__le__D,axiom,
    ! [N: nat,M5: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ N ) @ M5 )
     => ? [M6: nat] :
          ( M5
          = ( suc @ M6 ) ) ) ).

% Suc_le_D
thf(fact_236_le__SucI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ ( suc @ N ) ) ) ).

% le_SucI
thf(fact_237_le__SucE,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ ( suc @ N ) )
     => ( ~ ( ord_less_eq @ nat @ M @ N )
       => ( M
          = ( suc @ N ) ) ) ) ).

% le_SucE
thf(fact_238_Suc__leD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ M ) @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% Suc_leD
thf(fact_239_diff__less__Suc,axiom,
    ! [M: nat,N: nat] : ( ord_less @ nat @ ( minus_minus @ nat @ M @ N ) @ ( suc @ M ) ) ).

% diff_less_Suc
thf(fact_240_Suc__diff__Suc,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( ( suc @ ( minus_minus @ nat @ M @ ( suc @ N ) ) )
        = ( minus_minus @ nat @ M @ N ) ) ) ).

% Suc_diff_Suc
thf(fact_241_Suc__diff__le,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_eq @ nat @ N @ M )
     => ( ( minus_minus @ nat @ ( suc @ M ) @ N )
        = ( suc @ ( minus_minus @ nat @ M @ N ) ) ) ) ).

% Suc_diff_le
thf(fact_242_GreatestM__natI,axiom,
    ! [A: $tType,P2: A > $o,K: A,M: A > nat,B3: nat] :
      ( ( P2 @ K )
     => ( ! [Y4: A] :
            ( ( P2 @ Y4 )
           => ( ord_less @ nat @ ( M @ Y4 ) @ B3 ) )
       => ( P2 @ ( hilbert_GreatestM @ A @ nat @ M @ P2 ) ) ) ) ).

% GreatestM_natI
thf(fact_243_GreatestMI2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [P2: A > $o,X3: A,M: A > B,Q: A > $o] :
          ( ( P2 @ X3 )
         => ( ! [Y4: A] :
                ( ( P2 @ Y4 )
               => ( ord_less_eq @ B @ ( M @ Y4 ) @ ( M @ X3 ) ) )
           => ( ! [X4: A] :
                  ( ( P2 @ X4 )
                 => ( ! [Y2: A] :
                        ( ( P2 @ Y2 )
                       => ( ord_less_eq @ B @ ( M @ Y2 ) @ ( M @ X4 ) ) )
                   => ( Q @ X4 ) ) )
             => ( Q @ ( hilbert_GreatestM @ A @ B @ M @ P2 ) ) ) ) ) ) ).

% GreatestMI2
thf(fact_244_GreatestM__nat__le,axiom,
    ! [A: $tType,P2: A > $o,X3: A,M: A > nat,B3: nat] :
      ( ( P2 @ X3 )
     => ( ! [Y4: A] :
            ( ( P2 @ Y4 )
           => ( ord_less @ nat @ ( M @ Y4 ) @ B3 ) )
       => ( ord_less_eq @ nat @ ( M @ X3 ) @ ( M @ ( hilbert_GreatestM @ A @ nat @ M @ P2 ) ) ) ) ) ).

% GreatestM_nat_le
thf(fact_245_prod__decode__aux_Oinduct,axiom,
    ! [P2: nat > nat > $o,A0: nat,A1: nat] :
      ( ! [K2: nat,M6: nat] :
          ( ( ~ ( ord_less_eq @ nat @ M6 @ K2 )
           => ( P2 @ ( suc @ K2 ) @ ( minus_minus @ nat @ M6 @ ( suc @ K2 ) ) ) )
         => ( P2 @ K2 @ M6 ) )
     => ( P2 @ A0 @ A1 ) ) ).

% prod_decode_aux.induct
thf(fact_246_remdups__adj__adjacent,axiom,
    ! [A: $tType,I3: nat,Xs: list @ A] :
      ( ( ord_less @ nat @ ( suc @ I3 ) @ ( size_size @ ( list @ A ) @ ( remdups_adj @ A @ Xs ) ) )
     => ( ( nth @ A @ ( remdups_adj @ A @ Xs ) @ I3 )
       != ( nth @ A @ ( remdups_adj @ A @ Xs ) @ ( suc @ I3 ) ) ) ) ).

% remdups_adj_adjacent
thf(fact_247_remdups__adj__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( remdups_adj @ A @ ( rev @ A @ Xs ) )
      = ( rev @ A @ ( remdups_adj @ A @ Xs ) ) ) ).

% remdups_adj_rev
thf(fact_248_sorted__remdups__adj,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( linorder_sorted @ A @ ( remdups_adj @ A @ Xs ) ) ) ) ).

% sorted_remdups_adj
thf(fact_249_remdups__adj__length,axiom,
    ! [A: $tType,Xs: list @ A] : ( ord_less_eq @ nat @ ( size_size @ ( list @ A ) @ ( remdups_adj @ A @ Xs ) ) @ ( size_size @ ( list @ A ) @ Xs ) ) ).

% remdups_adj_length
thf(fact_250_nth__tl,axiom,
    ! [A: $tType,N: nat,X3: list @ A] :
      ( ( ord_less @ nat @ N @ ( size_size @ ( list @ A ) @ ( tl @ A @ X3 ) ) )
     => ( ( nth @ A @ ( tl @ A @ X3 ) @ N )
        = ( nth @ A @ X3 @ ( suc @ N ) ) ) ) ).

% nth_tl
thf(fact_251_Suc__pred,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ( ( suc @ ( minus_minus @ nat @ N @ ( suc @ ( zero_zero @ nat ) ) ) )
        = N ) ) ).

% Suc_pred
thf(fact_252_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_253_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero

%----Type constructors (20)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( preorder @ A7 @ ( type2 @ A7 ) )
     => ( preorder @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( order @ A7 @ ( type2 @ A7 ) )
     => ( order @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( ord @ A7 @ ( type2 @ A7 ) )
     => ( ord @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Groups_Ominus,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( minus @ A7 @ ( type2 @ A7 ) )
     => ( minus @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_Nat_Onat___Conditionally__Complete__Lattices_Oconditionally__complete__linorder,axiom,
    condit1037483654norder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_1,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Ono__top,axiom,
    no_top @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_2,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_3,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ominus_4,axiom,
    minus @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat @ ( type2 @ nat ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_5,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_6,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_7,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_8,axiom,
    ord @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ominus_9,axiom,
    minus @ $o @ ( type2 @ $o ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( ( ord_less @ nat @ n @ ( size_size @ ( list @ a ) @ xs ) )
     => ( ( stream370371455e_snth @ a @ ( stream1035003186_shift @ a @ xs @ s ) @ n )
        = ( nth @ a @ xs @ n ) ) )
    & ( ~ ( ord_less @ nat @ n @ ( size_size @ ( list @ a ) @ xs ) )
     => ( ( stream370371455e_snth @ a @ ( stream1035003186_shift @ a @ xs @ s ) @ n )
        = ( stream370371455e_snth @ a @ s @ ( minus_minus @ nat @ n @ ( size_size @ ( list @ a ) @ xs ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
